#ifndef __IFocusListener__
#define __IFocusListener__

#include <Basics/CCountedObject.hpp>

//	===========================================================================

/**
 * @cond
 */
#ifndef __IWINDOW_GUARD__
#define __IWINDOW_GUARD__
	namespace Exponent { namespace GUI { namespace Windowing { interface IWindow; } } }
	using Exponent::GUI::Windowing::IWindow;
#endif
/**
 * @endcond
 */

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IFocusListener IFocusListener.hpp
			 * @brief Allows windows to respond to focus events
			 *
			 * @date 18/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IFocusListener.hpp,v 1.5 2007/02/11 02:16:22 paul Exp $
			 */
			interface IFocusListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IFocusListener() { }

				/**
				 * Destruction
				 */
				virtual ~IFocusListener() { }

//	===========================================================================

				/**
				 * Window gained the focus
				 * @param window The window that has been resized
				 */
				virtual void gainedFocus(IWindow *window) = 0;

				/**
				 * Window lost the focus
				 * @param window The window that has been resized
				 */
				virtual void lostFocus(IWindow *window) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IFocusListener.hpp